﻿<%@ Page Title="Follow Up Event Reminders" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="EventReminders.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.EventReminders" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server" />

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">
    <script type = "text/javascript">

        $(document).ready(function()
        {
            $('input[id*=ButtonSnooze]').attr('disabled', 'disabled');

            $('span.redLabel').css({ "color": "#ff0000", "font-size": "x-large" });

            $('td.sideMenuColumn').remove();

            $('.tableView select[id*=DropDownSnoozeDurations]').change(function()
            {
                if ($(this).find(":selected").val() == 0) {
                    $(this).closest('tr').find('input[id*=ButtonSnooze]').attr('disabled', 'disabled');
                }
                else {
                    $(this).closest('tr').find('input[id*=ButtonSnooze]').removeAttr('disabled');
                }
            });
        });
    
    </script>    
    <br />
        <asp:Label ID = "ReminderWarningLabel" runat = "server" CssClass = "redLabel" Text = "Reminder!"></asp:Label>
    <br />

    <asp:GridView ID="GridViewReferralEventReminders" runat="server" DataSourceID="ObjectDataSourceEventReminders" AutoGenerateColumns="false"
        AllowPaging="True" PageSize="20" DataKeyNames="ReferralId, ContactId, ActivityId" OnRowCommand="EventReminders_RowCommand" AllowSorting="true" 
        CssClass="gridRegistry" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty">
       <EmptyDataTemplate>
            No reminders exist for any referrals
       </EmptyDataTemplate> 
        
        <Columns>
            <asp:TemplateField HeaderText="Referral Number" SortExpression="ReferralId" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelRefID" runat = "server" 
                        Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReferralId"))) %>' ></asp:Label> 
                </ItemTemplate> 
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Patient Name" SortExpression="LAST_NAME">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientFullName"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Reason" SortExpression="REASON">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelReason" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("Reason"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Due Date" SortExpression="DUE_DATE">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelDueDate" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("NormalizedDueDate"))) %>' ></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
                                             
            <asp:TemplateField HeaderText="Remind Me On" SortExpression="REMINDER_DATE">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelReminderDate" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("NormalizedReminderDate"))) %>' ></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="" SortExpression="FOLLOW_UP_TYPE" Visible="false">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelFollowupType" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("FollowUpType"))) %>' ></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" AccessibleHeaderText = "Select"  />
            
            <asp:TemplateField HeaderText="">
                        
                    <ItemTemplate>
                        &nbsp;
                        <asp:DropDownList ID = "DropDownSnoozeDurations" runat = "server" 
                            DataSourceID = "ObjectDataSourceSnoozeDurations" 
                            DataValueField="Key" DataTextField="Value" AppendDataBoundItems = "true">
                            <asp:ListItem Value = "0" Text = "(Select Period)"></asp:ListItem>
                        
                        </asp:DropDownList>
                        &nbsp;
                        <asp:Button ID = "ButtonSnooze" runat = "server" Text = "Snooze" CommandName = "Snooze" CommandArgument="<%# Container.DataItemIndex %>" />   
                        &nbsp;
                    </ItemTemplate>                            
            </asp:TemplateField> 
            
        </Columns>
                
    </asp:GridView>    
            
    <asp:ObjectDataSource ID="ObjectDataSourceEventReminders" runat="server" 
        SelectMethod="GetEventReminders" 
        SelectCountMethod="GetEventRemindersCount" 
        StartRowIndexParameterName="START_ROW" 
        MaximumRowsParameterName="MAX_ROWS" 
        SortParameterName="SORT_COLUMN"
        EnablePaging="True" 
        TypeName="VIRP.EFR.BLL.EventRemindersManager"
        DataObjectTypeName="VIRP.EFR.BO.ReferralFollowUp"
        OnSelected = "EventReminders_Selected" >     
        <SelectParameters>
            <asp:Parameter Name="CURRENT_USER" Type="String" />
            <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="Int32" />
            <asp:Parameter Name="PATIENT_LAST_NAME" Type="String" />
            <asp:Parameter Name="REMINDER" Type="Boolean" />
            <asp:Parameter Name="SORT_COLUMN" Type="String" />
            <asp:Parameter Name="START_ROW" Type="Int32" />
            <asp:Parameter Name="MAX_ROWS" Type="Int32" />
        </SelectParameters>            
   </asp:ObjectDataSource>

   <asp:ObjectDataSource ID="ObjectDataSourceSnoozeDurations" runat="server" 
        SelectMethod="GetBiomonitoringFollowupDurations" 
        TypeName="VIRP.EFR.BLL.EventRemindersManager">
       <SelectParameters>
            <asp:Parameter Name="CURRENT_USER" Type="String" />
            <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="Int32" />
        </SelectParameters>    
  </asp:ObjectDataSource>
   
</asp:Content>